#include <algorithm>
#include <cstdint>
#include <cstring>
#include <iostream>
#include <stack>
#include <tuple>
#include <unordered_map>
#include <vector>

typedef std::unordered_map<uint16_t, std::unordered_map<uint16_t, int16_t>> Graph;
constexpr int16_t INF = 30000;
constexpr int16_t NEG_INF = -30000;
constexpr int16_t unvisited = -1;

[[gnu::noreturn]]
void solve(const std::string& circle, const uint32_t circle_size) noexcept {
	constexpr char DELIVERY = '#';
	constexpr char CHARACTER = '+';
	constexpr char EMPTY = '.';
	
	uint32_t shortest_distance = UINT32_MAX;
	uint32_t current_distance = UINT32_MAX;
	uint32_t it = 0;
	uint32_t rit = circle_size - 1;
	uint32_t character_position;
	bool found_delivery = false;
	bool found_character = false;

	while(true){
		if(found_character == false) {
			if(circle[it] == CHARACTER) {
				found_character = true;
				character_position = it;
				if(found_delivery == false) {
					// ako smo nasli karaktera a nismo nasli
					// delivery znaci da moramo da proverimo
					// jednom unazad do prvog delivery od kraja
					// stringa, razdaljina je pozicija karaktera (jer krece od 0)
					// i onda plus duzina stringa - rit (len - len + 1)
					while(rit > character_position) {
						if(circle[rit] == DELIVERY) {
							current_distance = (character_position) + (circle_size - rit); // . . . + . . #, + . . . . . #, okej je
							break;
						}
						--rit;
					}
					shortest_distance = std::min(shortest_distance, current_distance);

					// sad treba da proverimo od karaktera do najblizeg sa desne strane
			
					while(it < circle_size) {
						if(circle[it] == DELIVERY){
							current_distance = it - character_position; // + . . . #, . + . . #, matematika je dobra
							break;
						}
						++it;
					}
					shortest_distance = std::min(shortest_distance, current_distance);
				} else {
					shortest_distance = std::min(shortest_distance, current_distance); // vec smo našli levo, sad desno
					while(it < circle_size) {
						if(circle[it] == DELIVERY){
							current_distance = it - character_position; // + . . . #, . + . . #, matematika je dobra
							break;
						}
						++it;
					}
				}	
				std::cout << shortest_distance;
				std::exit(0);
			}
		}

		if(found_delivery == false) {
			if(circle[it] == DELIVERY) {
				found_delivery = true;
				current_distance = 1;
			}
		} else {
			++current_distance;
			if(circle[it] == DELIVERY)
				current_distance = 1; // restartujemo
		}
		++it;
	}

	std::exit(0);
}

int main() noexcept {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  std::cout.tie(nullptr);
  std::cerr.tie(nullptr);
	
	// constexpr uint32_t MAX_SIZE = 500000;
	std::string circle;
	uint32_t circle_size;

	std::cin >> circle_size;
	circle.reserve(circle_size);
	std::getline(std::cin, circle);

	solve(circle, circle_size);
}